/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.integrator.IVWComponentRegistrationListener;
import filenet.vw.toolkit.admin.property.integrator.VWComponentRegistrationItem;
import filenet.vw.toolkit.admin.property.integrator.VWComponentRegistrationListCellRenderer;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWFileFilter;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VWLibraryRegistrationPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private JList m_list = null;
    private DefaultListModel m_listModel = null;
    private VWToolbarBorder m_listBorder = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private Container m_parent = null;
    private VWSystemConfiguration m_systemConfiguration = null;
    private boolean m_bIsModified = false;
    private FileDialog m_fileDialog = null;
    private EventListenerList m_listenerList = null;

    public VWLibraryRegistrationPanel(Frame parent, VWSystemConfiguration vwSystemConfiguration) {
        try {
            this.m_parent = parent;
            this.m_systemConfiguration = vwSystemConfiguration;
            this.initLayout();
            this.loadConfigurationInformation();
            this.updateButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWLibraryRegistrationPanel(JDialog parent, VWSystemConfiguration vwSystemConfiguration) {
        try {
            this.m_parent = parent;
            this.m_systemConfiguration = vwSystemConfiguration;
            this.initLayout();
            this.loadConfigurationInformation();
            this.updateButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateComponentList() {
        boolean bOk = true;
        if (this.m_listModel != null) {
            int sz = this.m_listModel.size();
            for (int i = 0; i < sz; ++i) {
                VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)this.m_listModel.getElementAt(i);
                if (aItem == null || aItem.isValid()) continue;
                bOk = false;
                break;
            }
        }
        return bOk;
    }

    public void refreshComponentList() {
        try {
            if (this.m_listModel != null) {
                int sz = this.m_listModel.size();
                for (int i = 0; i < sz; ++i) {
                    VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)this.m_listModel.getElementAt(i);
                    if (aItem == null) continue;
                    File file = new File(aItem.getName());
                    if (!file.exists()) {
                        aItem.setValid(false);
                        aItem.setInfo(VWResource.ItemCannotBeFound.toString(aItem.getName()));
                        continue;
                    }
                    aItem.setValid(true);
                    aItem.setInfo(null);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addRegistrationActionListener(IVWComponentRegistrationListener listener) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new EventListenerList();
        }
        this.m_listenerList.add(IVWComponentRegistrationListener.class, listener);
    }

    public void valueChanged(ListSelectionEvent event) {
        this.updateButtonState();
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    if (this.m_fileDialog == null) {
                        if (this.m_parent instanceof Frame) {
                            this.m_fileDialog = new FileDialog((Frame)this.m_parent, VWResource.SelectJarFile, 0);
                        } else if (this.m_parent instanceof Dialog) {
                            this.m_fileDialog = new FileDialog((Dialog)this.m_parent, VWResource.SelectJarFile, 0);
                        }
                        if (this.m_fileDialog != null) {
                            this.m_fileDialog.setFilenameFilter(new VWFileFilter(".jar"));
                        }
                    }
                    if (this.m_fileDialog != null) {
                        this.m_fileDialog.setFile("*.jar");
                        this.m_fileDialog.setVisible(true);
                        String sourceFile = this.m_fileDialog.getFile();
                        if (sourceFile != null) {
                            File file = new File(this.m_fileDialog.getDirectory() + sourceFile);
                            if (file.exists() && (file.isDirectory() || file.getPath().endsWith(".jar"))) {
                                VWComponentRegistrationItem aItem = new VWComponentRegistrationItem(file.getPath());
                                this.m_listModel.addElement(aItem);
                                this.m_bIsModified = true;
                                this.fireRegistrationActionEvent();
                            } else {
                                JOptionPane.showMessageDialog(this.m_parent, VWResource.InvalidLibraryPath.toString(file.getPath()), VWResource.ErrorMessage, 0);
                            }
                        }
                    }
                    this.m_listBorder.getControl(16).requestFocus();
                    break;
                }
                case 0x10000000: {
                    int[] indexes = this.m_list.getSelectedIndices();
                    if (indexes == null || indexes.length <= 0) break;
                    for (int i = indexes.length - 1; i >= 0; --i) {
                        this.m_listModel.remove(indexes[i]);
                    }
                    this.m_bIsModified = true;
                    if (indexes.length == 1) {
                        if (indexes[0] < this.m_listModel.size()) {
                            this.m_list.setSelectedIndex(indexes[0]);
                        } else if (this.m_listModel.size() > 0) {
                            this.m_list.setSelectedIndex(indexes[0] - 1);
                        }
                    }
                    this.fireRegistrationActionEvent();
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            int index = this.m_list.getSelectedIndex();
            if (event.getSource().equals(this.m_upButton)) {
                VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)this.m_listModel.remove(index);
                this.m_listModel.add(index - 1, aItem);
                this.m_list.setSelectedIndex(index - 1);
                this.m_bIsModified = true;
            } else if (event.getSource().equals(this.m_downButton)) {
                VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)this.m_listModel.remove(index);
                this.m_listModel.add(index + 1, aItem);
                this.m_list.setSelectedIndex(index + 1);
                this.m_bIsModified = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_list != null) {
            this.m_list.removeAll();
            this.m_list = null;
        }
        if (this.m_listModel != null) {
            this.m_listModel.removeAllElements();
            this.m_listModel = null;
        }
        if (this.m_listBorder != null) {
            this.m_listBorder.releaseReferences();
            this.m_listBorder = null;
        }
        if (this.m_upButton != null) {
            this.m_upButton.removeActionListener(this);
            this.m_upButton.removeAll();
            this.m_upButton = null;
        }
        if (this.m_downButton != null) {
            this.m_downButton.removeActionListener(this);
            this.m_downButton.removeAll();
            this.m_downButton = null;
        }
        this.m_parent = null;
        this.m_systemConfiguration = null;
        if (this.m_fileDialog != null) {
            this.m_fileDialog.removeAll();
            this.m_fileDialog = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWComponentRegistrationListener.class, (IVWComponentRegistrationListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.removeAll();
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected String[] getLibraries() {
        String[] libraries = null;
        if (this.m_listModel != null && this.m_listModel.size() > 0) {
            libraries = new String[this.m_listModel.size()];
            for (int i = 0; i < this.m_listModel.size(); ++i) {
                VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)this.m_listModel.getElementAt(i);
                if (aItem == null) continue;
                libraries[i] = aItem.getName();
            }
        }
        return libraries;
    }

    protected boolean save() {
        return this.saveConfigurationInformation();
    }

    private void initLayout() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            this.m_listBorder = new VWToolbarBorder(VWResource.JarFileLocations, 0x10000010);
            this.m_listBorder.addToolbarBorderActionNotifier(this);
            JPanel listPanel = this.m_listBorder.getClientPanel();
            listPanel.setLayout(new BorderLayout());
            this.m_listModel = new DefaultListModel();
            this.m_list = new JList(this.m_listModel);
            this.m_list.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_list.setSelectionMode(2);
            this.m_list.addListSelectionListener(this);
            this.m_list.setCellRenderer(new VWComponentRegistrationListCellRenderer());
            listPanel.add((Component)this.m_list, "Center");
            gbCons.fill = 1;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 5);
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            this.add((Component)this.m_listBorder, gbCons);
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            ++gbCons.gridx;
            this.add((Component)this.createMoveUpDownButtonPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createMoveUpDownButtonPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            this.m_upButton = new JButton(VWImageLoader.createImageIcon("up.gif"));
            this.m_upButton.setToolTipText(VWResource.MoveUp);
            this.m_upButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_upButton.addActionListener(this);
            panel.add((Component)this.m_upButton, gbCons);
            this.m_downButton = new JButton(VWImageLoader.createImageIcon("down.gif"));
            this.m_downButton.setToolTipText(VWResource.MoveDown);
            this.m_downButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_downButton.addActionListener(this);
            panel.add((Component)this.m_downButton, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateButtonState() {
        boolean bMultiSelection;
        if (this.m_list == null) {
            return;
        }
        int index = this.m_list.getSelectedIndex();
        boolean bItemSelected = index != -1;
        boolean bl = bMultiSelection = bItemSelected && this.m_list.getSelectedIndices().length > 1;
        if (index == 0 || bMultiSelection) {
            this.m_upButton.setEnabled(false);
        } else {
            this.m_upButton.setEnabled(bItemSelected);
        }
        if (index == this.m_list.getModel().getSize() - 1 || bMultiSelection) {
            this.m_downButton.setEnabled(false);
        } else {
            this.m_downButton.setEnabled(bItemSelected);
        }
        this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 16));
        if (bItemSelected) {
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x10000000));
        }
    }

    private void loadConfigurationInformation() {
        try {
            VWAttributeInfo attributeInfo;
            String libraryFiles;
            Vector<String> libraries = new Vector<String>();
            if (this.m_systemConfiguration != null && (libraryFiles = (String)(attributeInfo = this.m_systemConfiguration.getAttributeInfo()).getFieldValue("F_AdditionalLibraryFiles")) != null && libraryFiles.length() > 0) {
                StringTokenizer st = new StringTokenizer(libraryFiles, ",");
                while (st.hasMoreTokens()) {
                    libraries.addElement(st.nextToken().trim());
                }
            }
            for (int i = 0; i < libraries.size(); ++i) {
                String libraryName = (String)libraries.elementAt(i);
                VWComponentRegistrationItem aItem = new VWComponentRegistrationItem(libraryName);
                File file = new File(libraryName);
                if (!file.exists()) {
                    aItem.setValid(false);
                    aItem.setInfo(VWResource.ItemCannotBeFound.toString(aItem.getName()));
                }
                this.m_listModel.addElement(aItem);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean saveConfigurationInformation() {
        try {
            if (this.m_systemConfiguration != null && this.m_listModel != null) {
                StringBuffer attributeString = new StringBuffer();
                for (int i = 0; i < this.m_listModel.size(); ++i) {
                    VWComponentRegistrationItem aItem;
                    if (i > 0) {
                        attributeString.append(", ");
                    }
                    if ((aItem = (VWComponentRegistrationItem)this.m_listModel.getElementAt(i)) == null) continue;
                    attributeString.append(aItem.getName());
                }
                VWAttributeInfo attributeInfo = this.m_systemConfiguration.getAttributeInfo();
                attributeInfo.setFieldValue("F_AdditionalLibraryFiles", attributeString.toString());
                this.m_systemConfiguration.setAttributeInfo(attributeInfo);
            }
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    private void fireRegistrationActionEvent() {
        if (this.m_listenerList == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWComponentRegistrationListener.class) continue;
            ((IVWComponentRegistrationListener)listeners[i + 1]).refreshComponentList();
        }
    }
}

